package com.vmware.samples.globalview.views {

import com.vmware.flexutil.events.MethodReturnEvent;
import com.vmware.samples.globalview.EchoServiceProxy;
import com.vmware.ui.events.NavigationRequest;

import flash.events.EventDispatcher;
import flash.events.MouseEvent;

import mx.controls.Alert;
import mx.resources.ResourceManager;

[Event(name="{com.vmware.ui.events.NavigationRequest.NAVIGATION_REQUEST}",
      type="com.vmware.ui.events.NavigationRequest")]
/**
 * Class implementing the MainView logic
 */
public class MainViewMediator extends EventDispatcher {
   // Settings view's extendion id (defined in plugin.xml)
   private static const SETTINGVIEW_ID:String = "com.vmware.samples.globalviewui.settingView";
   private var _view:MainView;

   // Define a global proxy instance with the InjectableProxy tag
   [InjectableProxy]
   public var proxy:EchoServiceProxy;

   [View]
   /** The view associated with this mediator. */
   public function set view(value:MainView):void {
      // The view is injected here by the Framework when it is first created,
      // and reset to null when it is no longer needed.
      if ((value == null) && (_view != null)) {
         _view.helloButton.removeEventListener(MouseEvent.CLICK, onButtonClick);
         _view.linkButton.removeEventListener(MouseEvent.CLICK, onLinkButtonClick);
      }

      _view = value;

      if (_view == null) {
         return;
      }
      _view.helloButton.addEventListener(MouseEvent.CLICK, onButtonClick);
      _view.linkButton.addEventListener(MouseEvent.CLICK, onLinkButtonClick);
   }

   public function get view():MainView {
      return _view;
   }

   private function onButtonClick(click:MouseEvent):void {
      var message:String = ResourceManager.getInstance().
            getString("com_vmware_samples_globalview", "world.text");
      // Async call to the java service
      proxy.echo(message, onMethodResult);
   }

   private function onLinkButtonClick(click:MouseEvent):void {
      // Jump to the Settings view
      var event:NavigationRequest = new NavigationRequest();
      event.targetViewUid = SETTINGVIEW_ID;
      dispatchEvent(event);
   }

   /**
    * Callback from the EchoService
    *
    * @param event Method response.
    */
   private function onMethodResult(event:MethodReturnEvent):void {
      if (event.error != null) {
         Alert.show("Error calling echo: " + event.error.message);
      } else {
         Alert.show(event.result as String);
      }
   }
}
}